<?
// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('banning', 'cpuser');
// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_banning.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminipbans'))
{
    print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
$vbulletin->input->clean_array_gpc('r', array(
	'userid' => TYPE_INT
));
log_admin_action();

print_cp_header("IP ban manager");

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'list';
}


if($_REQUEST['do'] == 'list')
{
	//list
	print_table_start();
	print_table_header("IP Bans", 8);
	print_cells_row(array("IP","Cidr","","","","","",""));
	$q = $db->query("SELECT " . TABLE_PREFIX . "ipban.*," . TABLE_PREFIX . "user.username FROM " . TABLE_PREFIX . "ipban, " . TABLE_PREFIX . "user
			 WHERE " . TABLE_PREFIX . "ipban.setby = " . TABLE_PREFIX . "user.userid AND (expires > unix_timestamp() OR expires = 0)");
	while ($row = mysql_fetch_array($q))
	{
		$data = array();
		$data[] = long2ip($row['ip']);
		$data[] = "/" . $row['cidr'];
		$data[] = $row['username'];
		$data[] = ($row['registration']) ? 'Yes':'No';
		$data[] = ($row['exempt']) ? 'Yes':'No';
		$data[] = date("U",$row['expires']);
		$data[] = $row['reason'];
		$data[] = "<a href=\"?do=delete&ipbanid=".$row['ipbanid']."\">[Delete]</a>";
		print_cells_row($data);
		//echo long2ip($row['ip']) . " \n";
	}
	print_table_footer();
}

if($_REQUEST['do'] == 'doadd')
{
	//add
	$vbulletin->input->clean_array_gpc('p', array(
		'ip' => TYPE_STR,
		'period' => TYPE_STR,
		'reason' => TYPE_NOHTML,
		'cidr' => TYPE_INT,
		'exempt' => TYPE_BOOL,
		'registration' => TYPE_BOOL

	));

	// check that the number of days is valid
	if ($vbulletin->GPC['period'] != 'PERMANENT' AND !preg_match('#^(D|M|Y)_[1-9][0-9]?$#', $vbulletin->GPC['period']))
	{
		print_stop_message('invalid_ban_period_specified');
	}

	// if we've got this far all the incoming data is good
	if ($vbulletin->GPC['period'] == 'PERMANENT')
	{
		// make this ban permanent
		$liftdate = 0;
	}
	else
	{
		// get the unixtime for when this ban will be lifted
		$liftdate = convert_date_to_timestamp($vbulletin->GPC['period']);
	}

	//dont let an admin ban too large a range of ips at once
	if($vbulletin->GPC['cidr'] < 8)
	{
		$vbulletin->GPC['cidr'] = 8;
	}

	if(strlen($vbulletin->GPC['reason'])<1)
	{
		$vbulletin->GPC['reason'] = "No Reason";
	}

	$ip = ip2long($vbulletin->GPC['ip']);
	$cidrmask = ((pow(2,$vbulletin->GPC['cidr']) -1) << (32 - $vbulletin->GPC['cidr'])); //nb only works with ipv4. for ipv6 changes need to be made.

	$ip = $ip & $cidrmask;

	if(isset($vbulletin->config['SpecialUsers']['unbannableips']))
	{
		$unbannable = explode("|",$vbulletin->config['SpecialUsers']['unbannableips']);
		if(is_array($unbannable))
		{
			foreach($unbannable as $unbannableip)
			{
				$unbannableip = ip2long($unbannableip);
				$unbannableip = $unbannableip & $cidrmask;

				if($unbannableip == $ip)
				{
					print_stop_message('unbannable_ip');
				}
			}
		}
	}


	$db->query("INSERT INTO " . TABLE_PREFIX . "ipban (ip,cidr,registration,exempt,setby,reason,expires) VALUES
		    ($ip,{$vbulletin->GPC['cidr']},{$vbulletin->GPC['registration']},{$vbulletin->GPC['exempt']},
		    {$vbulletin->userinfo['userid']},'{$db->escape_string($vbulletin->GPC['reason'])}',$liftdate)");

	print_cp_message("IP ban added sucessfully.","ipbans.php",3);
}

if($_REQUEST['do'] == 'add')
{

	$temporary_phrase = $vbphrase['temporary_ban_options'];
	$permanent_phrase = $vbphrase['permanent_ban_options'];

	// make a list of banning period options
	$periodoptions = array(
		$temporary_phrase => array(
			'D_1'  => "1 $vbphrase[day]",
			'D_2'  => "2 $vbphrase[days]",
			'D_3'  => "3 $vbphrase[days]",
			'D_4'  => "4 $vbphrase[days]",
			'D_5'  => "5 $vbphrase[days]",
			'D_6'  => "6 $vbphrase[days]",
			'D_7'  => "7 $vbphrase[days]",
			'D_10' => "10 $vbphrase[days]",
			'D_14' => "2 $vbphrase[weeks]",
			'D_21' => "3 $vbphrase[weeks]",
			'M_1'  => "1 $vbphrase[month]",
			'M_2' => "2 $vbphrase[months]",
			'M_3' => "3 $vbphrase[months]",
			'M_4' => "4 $vbphrase[months]",
			'M_5' => "5 $vbphrase[months]",
			'M_6' => "6 $vbphrase[months]",
			'Y_1' => "1 $vbphrase[year]",
			'Y_2' => "2 $vbphrase[years]",
		),
		$permanent_phrase => array(
			'PERMANENT' => "$vbphrase[permanent] - $vbphrase[never_lift_ban]"
		)
	);

	foreach ($periodoptions["$temporary_phrase"] AS $thisperiod => $text)
	{
		if ($liftdate = convert_date_to_timestamp($thisperiod))
		{
			$periodoptions["$temporary_phrase"]["$thisperiod"] .= ' (' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $liftdate) . ')';
		}
	}
	//add form
	print_form_header("ipbans","doadd");
	print_table_header("Add IP ban");
	print_input_row("IP ","ip","");
	print_input_row(" CIDR (   ,   ,    32)","cidr",32);
	print_yes_no_row(" ?","registrations",1);
	print_yes_no_row(" IP? (  )","exempt",0);
	print_select_row($vbphrase['lift_ban_after'], 'period', $periodoptions, $vbulletin->GPC['period']);
	print_input_row("  ip", 'reason', '', true, 50, 250);
	print_submit_row();

}

if($_REQUEST['do'] == 'delete')
{
	$vbulletin->input->clean_array_gpc('g', array('ipbanid' => TYPE_INT));
	//print confirm form
	print_delete_confirmation("ipban", $vbulletin->GPC['ipbanid'], "ipbans", "dodelete", 'ipban', 0,'','ip');
}

if($_REQUEST['do'] == 'dodelete')
{
	//do the delete
	$vbulletin->input->clean_array_gpc('p', array('ipbanid' => TYPE_INT));
	$db->query("DELETE FROM " . TABLE_PREFIX . "ipban WHERE ipbanid = '{$vbulletin->GPC['ipbanid']}'");
	print_cp_message("Ip Ban deleted sucessfully","ipbans.php",3);
}
print_cp_footer();